/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.thresholdSwitch;

import com.google.common.base.Predicate;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlock;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3829;

public class ThresholdSwitchBlockEntity
extends SmartBlockEntity
implements class_3829 {
    public int onWhenAbove = 128;
    public int offWhenBelow = 64;
    public int currentMinLevel;
    public int currentLevel = -1;
    public int currentMaxLevel;
    public boolean inStacks;
    private boolean redstoneState = false;
    private boolean inverted = false;
    private boolean poweredAfterDelay = false;
    private ServerFilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    public ThresholdSwitchBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.THRESHOLD_SWITCH, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.onWhenAbove = view.method_71424("OnAboveAmount", 0);
        this.offWhenBelow = view.method_71424("OffBelowAmount", 0);
        this.currentLevel = view.method_71424("CurrentAmount", 0);
        this.currentMinLevel = view.method_71424("CurrentMinAmount", 0);
        this.currentMaxLevel = view.method_71424("CurrentMaxAmount", 0);
        this.inStacks = view.method_71433("InStacks", false);
        this.redstoneState = view.method_71433("Powered", false);
        this.inverted = view.method_71433("Inverted", false);
        this.poweredAfterDelay = view.method_71433("PoweredAfterDelay", false);
        super.read(view, clientPacket);
    }

    protected void writeCommon(class_11372 view) {
        view.method_71464("OnAboveAmount", (float)this.onWhenAbove);
        view.method_71464("OffBelowAmount", (float)this.offWhenBelow);
        view.method_71472("Inverted", this.inverted);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        this.writeCommon(view);
        view.method_71465("CurrentAmount", this.currentLevel);
        view.method_71465("CurrentMinAmount", this.currentMinLevel);
        view.method_71465("CurrentMaxAmount", this.currentMaxLevel);
        view.method_71472("InStacks", this.inStacks);
        view.method_71472("Powered", this.redstoneState);
        view.method_71472("PoweredAfterDelay", this.poweredAfterDelay);
        super.write(view, clientPacket);
    }

    @Override
    public void writeSafe(class_11372 view) {
        this.writeCommon(view);
        super.writeSafe(view);
    }

    public int getMinLevel() {
        return this.currentMinLevel;
    }

    public int getStockLevel() {
        return this.currentLevel;
    }

    public int getMaxLevel() {
        return this.currentMaxLevel;
    }

    public void updateCurrentLevel() {
        boolean changed = false;
        int prevLevel = this.currentLevel;
        int prevMaxLevel = this.currentMaxLevel;
        class_2338 target = this.getTargetPos();
        class_2586 targetBlockEntity = this.field_11863.method_8321(target);
        this.observedInventory.findNewCapability();
        this.observedTank.findNewCapability();
        if (targetBlockEntity instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable observable = (ThresholdSwitchObservable)targetBlockEntity;
            this.currentMinLevel = observable.getMinValue();
            this.currentLevel = observable.getCurrentValue();
            this.currentMaxLevel = observable.getMaxValue();
        } else if (this.observedInventory.hasInventory() || this.observedTank.hasInventory()) {
            int space;
            FluidStack stackInSlot;
            int slot;
            int size;
            this.currentMinLevel = 0;
            this.currentLevel = 0;
            this.currentMaxLevel = 0;
            if (this.observedInventory.hasInventory()) {
                class_1263 inv = (class_1263)this.observedInventory.getInventory();
                if (this.invVersionTracker.stillWaiting(inv)) {
                    this.currentLevel = prevLevel;
                    this.currentMaxLevel = prevMaxLevel;
                } else {
                    this.invVersionTracker.awaitNewVersion(inv);
                    size = inv.method_5439();
                    for (slot = 0; slot < size; ++slot) {
                        stackInSlot = inv.method_5438(slot);
                        int n = space = stackInSlot.method_7960() ? 64 : inv.method_58350((class_1799)stackInSlot);
                        if (space == 0) continue;
                        this.currentMaxLevel += space;
                        if (!this.filtering.test((class_1799)stackInSlot)) continue;
                        this.currentLevel += stackInSlot.method_7947();
                    }
                }
            }
            if (this.observedTank.hasInventory()) {
                FluidInventory tank = (FluidInventory)this.observedTank.getInventory();
                size = tank.size();
                for (slot = 0; slot < size; ++slot) {
                    stackInSlot = tank.getStack(slot);
                    space = tank.getMaxAmount(stackInSlot);
                    if (space == 0) continue;
                    this.currentMaxLevel += space;
                    if (!this.filtering.test(stackInSlot)) continue;
                    this.currentLevel += stackInSlot.getAmount();
                }
            }
        } else {
            this.currentMinLevel = -1;
            this.currentMaxLevel = -1;
            if (this.currentLevel == -1) {
                return;
            }
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(0)), 3);
            this.currentLevel = -1;
            this.redstoneState = false;
            this.sendData();
            this.scheduleBlockTick();
            return;
        }
        this.currentLevel = class_3532.method_15340((int)this.currentLevel, (int)this.currentMinLevel, (int)this.currentMaxLevel);
        changed = this.currentLevel != prevLevel;
        boolean previouslyPowered = this.redstoneState;
        if (this.redstoneState && this.currentLevel <= this.offWhenBelow) {
            this.redstoneState = false;
        } else if (!this.redstoneState && this.currentLevel >= this.onWhenAbove) {
            this.redstoneState = true;
        }
        boolean update = previouslyPowered != this.redstoneState;
        int displayLevel = 0;
        float normedLevel = (float)(this.currentLevel - this.currentMinLevel) / (float)(this.currentMaxLevel - this.currentMinLevel);
        if (this.currentLevel > 0) {
            displayLevel = (int)(1.0f + normedLevel * 4.0f);
        }
        this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(displayLevel)), update ? 3 : 2);
        if (update) {
            this.scheduleBlockTick();
        }
        if (changed || update) {
            DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
            this.notifyUpdate();
        }
    }

    private boolean isSuitableInventory(class_2586 be) {
        return be != null && !(be instanceof StockTickerBlockEntity) && !(ItemHelper.getInventory(this.field_11863, be.method_11016(), null, be, null) instanceof ProcessingInventory);
    }

    public class_2338 getTargetPos() {
        return this.field_11867.method_10093(ThresholdSwitchBlock.getTargetDirection(this.method_11010()));
    }

    public class_1799 getDisplayItemForScreen() {
        class_2338 target = this.getTargetPos();
        return new class_1799((class_1935)this.field_11863.method_8320(target).method_26204());
    }

    public ThresholdType getTypeOfCurrentTarget() {
        if (this.observedInventory.hasInventory()) {
            return ThresholdType.ITEM;
        }
        if (this.observedTank.hasInventory()) {
            return ThresholdType.FLUID;
        }
        if (this.field_11863.method_8321(this.getTargetPos()) instanceof ThresholdSwitchObservable) {
            return ThresholdType.CUSTOM;
        }
        return ThresholdType.UNSUPPORTED;
    }

    protected void scheduleBlockTick() {
        class_2248 block = this.method_11010().method_26204();
        if (!this.field_11863.method_8397().method_8677(this.field_11867, (Object)block)) {
            this.field_11863.method_64311(this.field_11867, block, 2, class_1953.field_9314);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            return;
        }
        this.updateCurrentLevel();
    }

    public void method_5448() {
        this.filtering.setFilter(class_1799.field_8037);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.filtering = new ServerFilteringBehaviour(this).withCallback($ -> {
            this.updateCurrentLevel();
            this.invVersionTracker.reset();
        });
        behaviours.add(this.filtering);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection(s));
        this.observedInventory = (InvManipulationBehaviour)((InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness()).withFilter((Predicate<class_2586>)((Predicate)this::isSuitableInventory));
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    public float getLevelForDisplay() {
        return this.currentLevel == -1 ? 0.0f : (float)this.currentLevel;
    }

    public boolean getState() {
        return this.redstoneState;
    }

    public boolean shouldBePowered() {
        return this.inverted != this.redstoneState;
    }

    public void updatePowerAfterDelay() {
        this.poweredAfterDelay = this.shouldBePowered();
        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        this.sendData();
    }

    public boolean isPowered() {
        return this.poweredAfterDelay;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (inverted == this.inverted) {
            return;
        }
        this.inverted = inverted;
        this.updatePowerAfterDelay();
    }

    public static enum ThresholdType {
        UNSUPPORTED,
        ITEM,
        FLUID,
        CUSTOM;

    }
}

